//: ## ![3DaysOfSwift.com Logo](PageHeader.png) ✅ Swift Study Guide
//: ### Study These Language Features
//: ©️ copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [3 Days of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: -------------------
//:
//: ## ✅ Closures
//:
//: Closures are grouped lines of code that can be executed together.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// a simple closure stored in a variable
let closure: () -> () = {
    print("Hello")
}

// execute
closure()

// execute again and again
closure()
closure()


//:
//: -------------------
//:
//: ## Functions are Closures
//:
//: Functions are a special case of named closure.
//:
//: Both use a slightly different syntax.
//:
//: -------------------
//:


// using a function
func greetFunction(person: String) -> String {
    return "Hello \(person),"
}

// using a closure (and storing it within a variable)
let greetClosure: (String) -> String = { person in
    return "Hello \(person),"
}


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ![3 Days Of Swift Logo](Footer.png) [Website](https://www.3DaysOfSwift.com) | [3 Days Of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: © Copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com). All rights reserved. Don't forget - come back when you've got an [interview](https://www.3DaysOfSwift.com/interview-prep)!
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
